/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class NamedTypeAccessor
extends TypeAccessor {
    NamedTypeAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, String string) throws SQLException {
        this.init(oracleStatement, 109, 109, s, false);
        this.initForDescribe(109, n, bl, n2, n3, n4, n5, n6, s, string);
        this.initForDataAccess(0, n, string);
    }

    NamedTypeAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, String string, OracleType oracleType) throws SQLException {
        this.init(oracleStatement, 109, 109, s, false);
        this.describeOtype = oracleType;
        this.initForDescribe(109, n, bl, n2, n3, n4, n5, n6, s, string);
        this.internalOtype = oracleType;
        this.initForDataAccess(0, n, string);
    }

    NamedTypeAccessor(OracleStatement oracleStatement, String string, short s, int n, boolean bl) throws SQLException {
        this.init(oracleStatement, 109, 109, s, bl);
        this.initForDataAccess(n, 0, string);
    }

    ARRAY getARRAY(int n) throws SQLException {
        return (ARRAY)this.getOracleObject(n);
    }

    OPAQUE getOPAQUE(int n) throws SQLException {
        return (OPAQUE)this.getOracleObject(n);
    }

    Object getObject(int n) throws SQLException {
        return this.getObject(n, this.statement.connection.getTypeMap());
    }

    Object getObject(int n, Map map) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            if (this.externalType == 0) {
                Datum datum = this.getOracleObject(n);
                if (datum == null) {
                    return null;
                }
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).toJdbc(map);
                }
                if (datum instanceof OPAQUE) {
                    return ((OPAQUE)datum).toJdbc(map);
                }
                return datum.toJdbc();
            }
            switch (this.externalType) {
                case 2008: {
                    map = null;
                }
                case 2000: 
                case 2002: 
                case 2003: 
                case 2007: {
                    Datum datum = this.getOracleObject(n);
                    if (datum == null) {
                        return null;
                    }
                    if (datum instanceof STRUCT) {
                        return ((STRUCT)datum).toJdbc(map);
                    }
                    return datum.toJdbc();
                }
            }
            DatabaseError.throwSqlException(4);
            return null;
        }
        return null;
    }

    Datum getOracleObject(int n) throws SQLException {
        DatumWithConnection datumWithConnection = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.pickledBytes(n);
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            OracleTypeADT oracleTypeADT = (OracleTypeADT)this.internalOtype;
            TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(oracleTypeADT.getFullName(), physicalConnection, byArray, 0L);
            switch (typeDescriptor.getTypeCode()) {
                case 2003: {
                    datumWithConnection = new ARRAY((ArrayDescriptor)typeDescriptor, byArray, physicalConnection);
                    break;
                }
                case 2002: {
                    datumWithConnection = new STRUCT((StructDescriptor)typeDescriptor, byArray, physicalConnection);
                    break;
                }
                case 2007: {
                    datumWithConnection = new OPAQUE((OpaqueDescriptor)typeDescriptor, byArray, physicalConnection);
                    break;
                }
                case 2008: {
                    datumWithConnection = new JAVA_STRUCT((StructDescriptor)typeDescriptor, byArray, physicalConnection);
                    break;
                }
                default: {
                    DatabaseError.throwSqlException(1);
                }
            }
        }
        return datumWithConnection;
    }

    STRUCT getSTRUCT(int n) throws SQLException {
        return (STRUCT)this.getOracleObject(n);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        super.initForDataAccess(n, n2, string);
        this.byteLength = this.statement.connection.namedTypeAccessorByteLen;
    }

    OracleType otypeFromName(String string) throws SQLException {
        if (!this.outBind) {
            return TypeDescriptor.getTypeDescriptor(string, this.statement.connection).getPickler();
        }
        if (this.externalType == 2003) {
            return ArrayDescriptor.createDescriptor(string, (Connection)this.statement.connection).getOracleTypeCOLLECTION();
        }
        if (this.externalType == 2007) {
            return OpaqueDescriptor.createDescriptor(string, (Connection)this.statement.connection).getPickler();
        }
        return StructDescriptor.createDescriptor(string, (Connection)this.statement.connection).getOracleTypeADT();
    }
}

