/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class UpdatableResultSet
extends BaseResultSet {
    static final int concurrencyType = 1008;
    static final int beginColumnIndex = 1;
    PhysicalConnection connection;
    OracleResultSet resultSet;
    boolean isCachedRset;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData rsetMetaData;
    private int rsetType;
    private int columnCount;
    private OraclePreparedStatement deleteStmt;
    private OraclePreparedStatement insertStmt;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged;
    private Object[] rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] typeInfo;
    private boolean isInserting;
    private boolean isUpdating;
    private int wasNull;
    private static final int VALUE_NULL = 1;
    private static final int VALUE_NOT_NULL = 2;
    private static final int VALUE_UNKNOWN = 3;
    private static final int VALUE_IN_RSET = 4;
    private static final int ASCII_STREAM = 1;
    private static final int BINARY_STREAM = 2;
    private static final int UNICODE_STREAM = 3;
    private static int _MIN_STREAM_SIZE = 4000;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:36:30_PST_2008";

    UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n, int n2) throws SQLException {
        this.init(scrollRsetStatement, oracleResultSetImpl, n, n2);
        this.getInternalMetadata();
        this.isCachedRset = false;
    }

    UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, ScrollableResultSet scrollableResultSet, int n, int n2) throws SQLException {
        this.init(scrollRsetStatement, scrollableResultSet, n, n2);
        scrollableResultSet.resetBeginColumnIndex();
        this.getInternalMetadata();
        this.isCachedRset = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean absolute(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                this.cancelRowChanges();
                return this.resultSet.absolute(n);
            }
        }
    }

    public synchronized void afterLast() throws SQLException {
        this.cancelRowChanges();
        this.resultSet.afterLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        this.cancelRowChanges();
        this.resultSet.beforeFirst();
    }

    private synchronized void cancelRowChanges() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                if (this.isInserting) {
                    this.cancelRowInserts();
                }
                if (this.isUpdating) {
                    this.cancelRowUpdates();
                }
            }
        }
    }

    private void cancelRowInserts() {
        if (this.isInserting) {
            this.isInserting = false;
            this.clearRowBuffer();
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.isUpdating) {
            this.isUpdating = false;
            this.clearRowBuffer();
        }
    }

    private void clearRowBuffer() {
        int n;
        if (this.rowBuffer != null) {
            n = 0;
            while (n < this.rowBuffer.length) {
                this.rowBuffer[n] = null;
                ++n;
            }
        }
        if (this.m_nullIndicator != null) {
            n = 0;
            while (n < this.m_nullIndicator.length) {
                this.m_nullIndicator[n] = false;
                ++n;
            }
        }
        if (this.typeInfo != null) {
            n = 0;
            while (n < this.typeInfo.length) {
                if (this.typeInfo[n] != null) {
                    int n2 = 0;
                    while (n2 < this.typeInfo[n].length) {
                        this.typeInfo[n][n2] = 0;
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
        this.resultSet.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.insertStmt != null) {
            this.insertStmt.close();
        }
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        if (this.deleteStmt != null) {
            this.deleteStmt.close();
        }
        if (this.scrollStmt != null) {
            this.scrollStmt.notifyCloseRset();
        }
        this.cancelRowInserts();
        this.connection = null;
        this.resultSet = null;
        this.scrollStmt = null;
        this.rsetMetaData = null;
        this.scrollStmt = null;
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
    }

    public synchronized void deleteRow() throws SQLException {
        if (this.isOnInsertRow()) {
            DatabaseError.throwSqlException(84);
        }
        this.prepareDeleteRowStatement();
        this.prepareDeleteRowBinds();
        this.executeDeleteRow();
    }

    private void executeDeleteRow() throws SQLException {
        if (this.deleteStmt.executeUpdate() == 0) {
            DatabaseError.throwSqlException(85);
        }
        if (this.isCachedRset) {
            ((ScrollableResultSet)this.resultSet).removeRowInCache(this.getRow());
        }
    }

    private void executeInsertRow() throws SQLException {
        if (this.insertStmt.executeUpdate() != 1) {
            DatabaseError.throwSqlException(85);
        }
    }

    private void executeUpdateRow() throws SQLException {
        block9: {
            try {
                if (this.updateStmt.executeUpdate() == 0) {
                    DatabaseError.throwSqlException(85);
                }
                if (!this.isCachedRset) break block9;
                if (this.autoRefetch) {
                    ((ScrollableResultSet)this.resultSet).refreshRowsInCache(this.getRow(), 1, 1000);
                    this.cancelRowUpdates();
                    break block9;
                }
                if (this.rowBuffer != null) {
                    int n = 1;
                    while (n < this.getColumnCount()) {
                        if (this.rowBuffer[n] != null || this.rowBuffer[n] == null && this.m_nullIndicator[n]) {
                            ((ScrollableResultSet)this.resultSet).setCurrentRowValueAt(this, n + 1, this.rowBuffer[n]);
                        }
                        ++n;
                    }
                }
                this.cancelRowUpdates();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (this.updateStmt != null) {
                    this.updateStmt.close();
                    this.updateStmt = null;
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (this.updateStmt != null) {
            this.updateStmt.close();
            this.updateStmt = null;
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string) - 1;
    }

    public synchronized boolean first() throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.first();
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        ARRAY aRRAY = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ARRAY)) {
                DatabaseError.throwSqlException(4, "getARRAY");
            }
            aRRAY = (ARRAY)datum;
        } else {
            this.setIsNull(4);
            aRRAY = this.resultSet.getARRAY(n + 1);
        }
        return aRRAY;
    }

    public synchronized Array getArray(int n) throws SQLException {
        return this.getARRAY(n);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Object object = this.getRowBufferAt(n);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n);
                    inputStream = datum.asciiStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.resultSet.getAsciiStream(n + 1);
        }
        return inputStream;
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        BFILE bFILE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BFILE)) {
                DatabaseError.throwSqlException(4, "getBFILE");
            }
            bFILE = (BFILE)datum;
        } else {
            this.setIsNull(4);
            bFILE = this.resultSet.getBFILE(n + 1);
        }
        return bFILE;
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        BLOB bLOB = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BLOB)) {
                DatabaseError.throwSqlException(4, "getBLOB");
            }
            bLOB = (BLOB)datum;
        } else {
            this.setIsNull(4);
            bLOB = this.resultSet.getBLOB(n + 1);
        }
        return bLOB;
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                bigDecimal = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            bigDecimal = this.resultSet.getBigDecimal(n + 1);
        }
        return bigDecimal;
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                bigDecimal = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            bigDecimal = this.resultSet.getBigDecimal(n + 1);
        }
        return bigDecimal;
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Object object = this.getRowBufferAt(n);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n);
                    inputStream = datum.binaryStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.resultSet.getBinaryStream(n + 1);
        }
        return inputStream;
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        boolean bl = false;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                bl = datum.booleanValue();
            }
        } else {
            this.setIsNull(4);
            bl = this.resultSet.getBoolean(n + 1);
        }
        return bl;
    }

    public synchronized byte getByte(int n) throws SQLException {
        byte by = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                by = datum.byteValue();
            }
        } else {
            this.setIsNull(4);
            by = this.resultSet.getByte(n + 1);
        }
        return by;
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                byArray = datum.getBytes();
            }
        } else {
            this.setIsNull(4);
            byArray = this.resultSet.getBytes(n + 1);
        }
        return byArray;
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        CHAR cHAR = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CHAR)) {
                DatabaseError.throwSqlException(4, "getCHAR");
            }
            cHAR = (CHAR)datum;
        } else {
            this.setIsNull(4);
            cHAR = this.resultSet.getCHAR(n + 1);
        }
        return cHAR;
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        CLOB cLOB = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CLOB)) {
                DatabaseError.throwSqlException(4, "getCLOB");
            }
            cLOB = (CLOB)datum;
        } else {
            this.setIsNull(4);
            cLOB = this.resultSet.getCLOB(n + 1);
        }
        return cLOB;
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        Reader reader = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Object object = this.getRowBufferAt(n);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof Reader) {
                    reader = (Reader)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n);
                    reader = datum.characterStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            reader = this.resultSet.getCharacterStream(n + 1);
        }
        return reader;
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.resultSet instanceof OracleResultSetImpl ? (((OracleResultSetImpl)this.resultSet).statement.accessors != null ? ((OracleResultSetImpl)this.resultSet).statement.numberOfDefinePositions : this.getInternalMetadata().getColumnCount()) : ((ScrollableResultSet)this.resultSet).getColumnCount();
        }
        return this.columnCount;
    }

    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        ResultSet resultSet = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            DatabaseError.throwSqlException(4, "getCursor");
        } else {
            this.setIsNull(4);
            resultSet = this.resultSet.getCursor(n + 1);
        }
        return resultSet;
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        if (customDatumFactory == null) {
            DatabaseError.throwSqlException(68);
        }
        CustomDatum customDatum = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            customDatum = customDatumFactory.create(datum, 0);
        } else {
            this.setIsNull(4);
            customDatum = this.resultSet.getCustomDatum(n + 1, customDatumFactory);
        }
        return customDatum;
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        DATE dATE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof DATE)) {
                DatabaseError.throwSqlException(4, "getDATE");
            }
            dATE = (DATE)datum;
        } else {
            this.setIsNull(4);
            dATE = this.resultSet.getDATE(n + 1);
        }
        return dATE;
    }

    public synchronized Date getDate(int n) throws SQLException {
        Date date = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                date = datum.dateValue();
            }
        } else {
            this.setIsNull(4);
            date = this.resultSet.getDate(n + 1);
        }
        return date;
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    date = ((DATE)datum).dateValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        date = dATE.dateValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            date = this.resultSet.getDate(n + 1, calendar);
        }
        return date;
    }

    public synchronized double getDouble(int n) throws SQLException {
        double d = 0.0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                d = datum.doubleValue();
            }
        } else {
            this.setIsNull(4);
            d = this.resultSet.getDouble(n + 1);
        }
        return d;
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    int getFirstUserColumnIndex() {
        return 1;
    }

    public synchronized float getFloat(int n) throws SQLException {
        float f = 0.0f;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                f = datum.floatValue();
            }
        } else {
            this.setIsNull(4);
            f = this.resultSet.getFloat(n + 1);
        }
        return f;
    }

    public synchronized INTERVALDS getINTERVALDS(int n) throws SQLException {
        INTERVALDS iNTERVALDS = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof INTERVALDS)) {
                DatabaseError.throwSqlException(4, "getINTERVALDS");
            }
            iNTERVALDS = (INTERVALDS)datum;
        } else {
            this.setIsNull(4);
            iNTERVALDS = this.resultSet.getINTERVALDS(n + 1);
        }
        return iNTERVALDS;
    }

    public synchronized INTERVALYM getINTERVALYM(int n) throws SQLException {
        INTERVALYM iNTERVALYM = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof INTERVALYM)) {
                DatabaseError.throwSqlException(4, "getINTERVALYM");
            }
            iNTERVALYM = (INTERVALYM)datum;
        } else {
            this.setIsNull(4);
            iNTERVALYM = this.resultSet.getINTERVALYM(n + 1);
        }
        return iNTERVALYM;
    }

    public synchronized int getInt(int n) throws SQLException {
        int n2 = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                n2 = datum.intValue();
            }
        } else {
            this.setIsNull(4);
            n2 = this.resultSet.getInt(n + 1);
        }
        return n2;
    }

    ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.rsetMetaData == null) {
            this.rsetMetaData = this.resultSet.getMetaData();
        }
        return this.rsetMetaData;
    }

    public synchronized long getLong(int n) throws SQLException {
        long l = 0L;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                l = datum.longValue();
            }
        } else {
            this.setIsNull(4);
            l = this.resultSet.getLong(n + 1);
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        if (((OracleStatement)this.scrollStmt).closed) {
            DatabaseError.throwSqlException(9, "getMetaData");
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                return new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, 1);
            }
        }
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        NUMBER nUMBER = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof NUMBER)) {
                DatabaseError.throwSqlException(4, "getNUMBER");
            }
            nUMBER = (NUMBER)datum;
        } else {
            this.setIsNull(4);
            nUMBER = this.resultSet.getNUMBER(n + 1);
        }
        return nUMBER;
    }

    private int getNumColumnsChanged() throws SQLException {
        int n = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.rowBuffer != null) {
            int n2 = 1;
            while (n2 < this.getColumnCount()) {
                if (this.rowBuffer[n2] != null || this.rowBuffer[n2] == null && this.m_nullIndicator[n2]) {
                    this.indexColsChanged[n++] = n2;
                }
                ++n2;
            }
        }
        return n;
    }

    public synchronized OPAQUE getOPAQUE(int n) throws SQLException {
        OPAQUE oPAQUE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof OPAQUE)) {
                DatabaseError.throwSqlException(4, "getOPAQUE");
            }
            oPAQUE = (OPAQUE)datum;
        } else {
            this.setIsNull(4);
            oPAQUE = this.resultSet.getOPAQUE(n + 1);
        }
        return oPAQUE;
    }

    public synchronized ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        if (oRADataFactory == null) {
            DatabaseError.throwSqlException(68);
        }
        ORAData oRAData = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            oRAData = oRADataFactory.create(datum, 0);
        } else {
            this.setIsNull(4);
            oRAData = this.resultSet.getORAData(n + 1, oRADataFactory);
        }
        return oRAData;
    }

    public synchronized Object getObject(int n) throws SQLException {
        Object object = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                object = datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            object = this.resultSet.getObject(n + 1);
        }
        return object;
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        Object object = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                object = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            object = this.resultSet.getObject(n + 1, map);
        }
        return object;
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        Datum datum = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            this.setIsNull(datum == null);
            datum = this.getRowBufferDatumAt(n);
        } else {
            this.setIsNull(4);
            datum = this.resultSet.getOracleObject(n + 1);
        }
        return datum;
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        RAW rAW = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof RAW)) {
                DatabaseError.throwSqlException(4, "getRAW");
            }
            rAW = (RAW)datum;
        } else {
            this.setIsNull(4);
            rAW = this.resultSet.getRAW(n + 1);
        }
        return rAW;
    }

    public synchronized REF getREF(int n) throws SQLException {
        REF rEF = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof REF)) {
                DatabaseError.throwSqlException(4, "getREF");
            }
            rEF = (REF)datum;
        } else {
            this.setIsNull(4);
            rEF = this.resultSet.getREF(n + 1);
        }
        return rEF;
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        ROWID rOWID = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ROWID)) {
                DatabaseError.throwSqlException(4, "getROWID");
            }
            rOWID = (ROWID)datum;
        } else {
            this.setIsNull(4);
            rOWID = this.resultSet.getROWID(n + 1);
        }
        return rOWID;
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    public synchronized int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    private Object getRowBufferAt(int n) throws SQLException {
        if (n < 1 || n > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "getRowBufferDatumAt");
        }
        if (this.rowBuffer != null) {
            return this.rowBuffer[n];
        }
        return null;
    }

    private Datum getRowBufferDatumAt(int n) throws SQLException {
        Object object;
        if (n < 1 || n > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "getRowBufferDatumAt");
        }
        Datum datum = null;
        if (this.rowBuffer != null && (object = this.rowBuffer[n]) != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                int n2 = n + 1;
                datum = SQLUtil.makeOracleDatum(this.connection, object, oracleResultSetMetaData.getColumnType(n2), null, oracleResultSetMetaData.isNCHAR(n2));
                this.rowBuffer[n] = datum;
            }
        }
        return datum;
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        STRUCT sTRUCT = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof STRUCT)) {
                DatabaseError.throwSqlException(4, "getSTRUCT");
            }
            sTRUCT = (STRUCT)datum;
        } else {
            this.setIsNull(4);
            sTRUCT = this.resultSet.getSTRUCT(n + 1);
        }
        return sTRUCT;
    }

    public synchronized short getShort(int n) throws SQLException {
        short s = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            long l = this.getLong(n);
            if (l > 65537L || l < -65538L) {
                DatabaseError.throwSqlException(26, "getShort");
            }
            s = (short)l;
        } else {
            this.setIsNull(4);
            s = this.resultSet.getShort(n + 1);
        }
        return s;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.scrollStmt);
    }

    public synchronized String getString(int n) throws SQLException {
        String string = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                string = datum.stringValue();
            }
        } else {
            this.setIsNull(4);
            string = this.resultSet.getString(n + 1);
        }
        return string;
    }

    public synchronized TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMP)) {
                DatabaseError.throwSqlException(4, "getTIMESTAMP");
            }
            tIMESTAMP = (TIMESTAMP)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMP = this.resultSet.getTIMESTAMP(n + 1);
        }
        return tIMESTAMP;
    }

    public synchronized TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMPLTZ)) {
                DatabaseError.throwSqlException(4, "getTIMESTAMPLTZ");
            }
            tIMESTAMPLTZ = (TIMESTAMPLTZ)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMPLTZ = this.resultSet.getTIMESTAMPLTZ(n + 1);
        }
        return tIMESTAMPLTZ;
    }

    public synchronized TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMPTZ)) {
                DatabaseError.throwSqlException(4, "getTIMESTAMPTZ");
            }
            tIMESTAMPTZ = (TIMESTAMPTZ)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMPTZ = this.resultSet.getTIMESTAMPTZ(n + 1);
        }
        return tIMESTAMPTZ;
    }

    public synchronized Time getTime(int n) throws SQLException {
        Time time = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                time = datum.timeValue();
            }
        } else {
            this.setIsNull(4);
            time = this.resultSet.getTime(n + 1);
        }
        return time;
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    time = ((DATE)datum).timeValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        time = dATE.timeValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            time = this.resultSet.getTime(n + 1, calendar);
        }
        return time;
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                timestamp = datum.timestampValue();
            }
        } else {
            this.setIsNull(4);
            timestamp = this.resultSet.getTimestamp(n + 1);
        }
        return timestamp;
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    timestamp = ((DATE)datum).timestampValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        timestamp = dATE.timestampValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            timestamp = this.resultSet.getTimestamp(n + 1, calendar);
        }
        return timestamp;
    }

    public int getType() throws SQLException {
        return this.rsetType;
    }

    public synchronized URL getURL(int n) throws SQLException {
        URL uRL = null;
        int n2 = this.getInternalMetadata().getColumnType(n);
        int n3 = SQLUtil.getInternalType(n2);
        if (n3 == 96 || n3 == 1 || n3 == 8) {
            try {
                uRL = new URL(this.getString(n));
            }
            catch (MalformedURLException malformedURLException) {
                DatabaseError.throwSqlException(136);
            }
        } else {
            throw new SQLException("Conversion to java.net.URL not supported.");
        }
        return uRL;
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Object object = this.getRowBufferAt(n);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n);
                    DBConversion dBConversion = this.connection.conversion;
                    byte[] byArray = datum.shareBytes();
                    if (datum instanceof RAW) {
                        inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                    } else if (datum instanceof CHAR) {
                        inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                    } else {
                        DatabaseError.throwSqlException(4, "getUnicodeStream");
                    }
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.resultSet.getUnicodeStream(n + 1);
        }
        return inputStream;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = this.resultSet.getWarnings();
        if (this.sqlWarning == null) {
            return sQLWarning;
        }
        SQLWarning sQLWarning2 = this.sqlWarning;
        while (sQLWarning2.getNextWarning() != null) {
            sQLWarning2 = sQLWarning2.getNextWarning();
        }
        sQLWarning2.setNextWarning(sQLWarning);
        return this.sqlWarning;
    }

    private void init(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n, int n2) throws SQLException {
        if (scrollRsetStatement == null || oracleResultSet == null || n2 != 1008) {
            DatabaseError.throwSqlException(68);
        }
        this.connection = ((OracleStatement)scrollRsetStatement).connection;
        this.resultSet = oracleResultSet;
        this.scrollStmt = scrollRsetStatement;
        this.rsetType = n;
        this.autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
        this.isInserting = false;
        this.isUpdating = false;
        this.wasNull = -1;
        this.rsetMetaData = null;
        this.columnCount = 0;
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.isOnInsertRow()) {
            DatabaseError.throwSqlException(83);
        }
        this.prepareInsertRowStatement();
        this.prepareInsertRowBinds();
        this.executeInsertRow();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    boolean isOnInsertRow() {
        return this.isInserting;
    }

    private boolean isRowBufferUpdatedAt(int n) {
        if (this.rowBuffer == null) {
            return false;
        }
        return this.rowBuffer[n] != null || this.m_nullIndicator[n];
    }

    final boolean isStreamType(int n) {
        return n == 2004 || n == 2005 || n == -4 || n == -1;
    }

    boolean isUpdatingRow() {
        return this.isUpdating;
    }

    public synchronized boolean last() throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.last();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.cancelRowInserts();
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (this.isOnInsertRow()) {
            return;
        }
        this.isInserting = true;
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
        }
        this.clearRowBuffer();
    }

    public synchronized boolean next() throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.next();
    }

    private int prepareCompareSelfBinds(OraclePreparedStatement oraclePreparedStatement, int n) throws SQLException {
        Datum datum = this.resultSet.getOracleObject(1);
        oraclePreparedStatement.setOracleObject(n, this.resultSet.getOracleObject(1));
        return n + 1;
    }

    private void prepareDeleteRowBinds() throws SQLException {
        int n = 1;
        n = this.prepareSubqueryBinds(this.deleteStmt, n);
        this.prepareCompareSelfBinds(this.deleteStmt, n);
    }

    private void prepareDeleteRowStatement() throws SQLException {
        if (this.deleteStmt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.deleteStmt = (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getDeleteSqlForUpdatableResultSet(this));
            this.deleteStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
            if (((OracleStatement)this.scrollStmt).sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.deleteStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareInsertRowBinds() throws SQLException {
        int n = 1;
        n = this.prepareSubqueryBinds(this.insertStmt, n);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        int n2 = 1;
        while (n2 < this.getColumnCount()) {
            Object object = this.getRowBufferAt(n2);
            if (object != null) {
                if (object instanceof Reader) {
                    this.insertStmt.setCharacterStream(n + n2 - 1, (Reader)object, this.typeInfo[n2][0]);
                } else if (object instanceof InputStream) {
                    if (this.typeInfo[n2][1] == 2) {
                        this.insertStmt.setBinaryStream(n + n2 - 1, (InputStream)object, this.typeInfo[n2][0]);
                    } else if (this.typeInfo[n2][1] == 1) {
                        this.insertStmt.setAsciiStream(n + n2 - 1, (InputStream)object, this.typeInfo[n2][0]);
                    }
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    if (oracleResultSetMetaData.isNCHAR(n2 + 1)) {
                        this.insertStmt.setFormOfUse(n + n2 - 1, (short)2);
                    }
                    this.insertStmt.setOracleObject(n + n2 - 1, datum);
                }
            } else {
                int n3 = this.getInternalMetadata().getColumnType(n2 + 1);
                if (n3 == 2006 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003) {
                    this.insertStmt.setNull(n + n2 - 1, n3, this.getInternalMetadata().getColumnTypeName(n2 + 1));
                } else {
                    this.insertStmt.setNull(n + n2 - 1, n3);
                }
            }
            ++n2;
        }
    }

    private void prepareInsertRowStatement() throws SQLException {
        if (this.insertStmt == null) {
            this.insertStmt = (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getInsertSqlForUpdatableResultSet(this));
            this.insertStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
            if (((OracleStatement)this.scrollStmt).sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.insertStmt.setEscapeProcessing(true);
            }
        }
    }

    private int prepareSubqueryBinds(OraclePreparedStatement oraclePreparedStatement, int n) throws SQLException {
        int n2 = this.scrollStmt.copyBinds(oraclePreparedStatement, n - 1);
        return n2 + 1;
    }

    private void prepareUpdateRowBinds(int n) throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.updateStmt, n2);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.indexColsChanged[n3];
            Object object = this.getRowBufferAt(n4);
            if (object != null) {
                if (object instanceof Reader) {
                    this.updateStmt.setCharacterStream(n2++, (Reader)object, this.typeInfo[n4][0]);
                } else if (object instanceof InputStream) {
                    if (this.typeInfo[n4][1] == 2) {
                        this.updateStmt.setBinaryStream(n2++, (InputStream)object, this.typeInfo[n4][0]);
                    } else if (this.typeInfo[n4][1] == 1) {
                        this.updateStmt.setAsciiStream(n2++, (InputStream)object, this.typeInfo[n4][0]);
                    }
                } else {
                    Datum datum = this.getRowBufferDatumAt(n4);
                    if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                        this.updateStmt.setFormOfUse(n2, (short)2);
                    }
                    this.updateStmt.setOracleObject(n2++, datum);
                }
            } else {
                int n5 = this.getInternalMetadata().getColumnType(n4 + 1);
                if (n5 == 2006 || n5 == 2002 || n5 == 2008 || n5 == 2007 || n5 == 2003) {
                    this.updateStmt.setNull(n2++, n5, this.getInternalMetadata().getColumnTypeName(n4 + 1));
                } else {
                    this.updateStmt.setNull(n2++, n5);
                }
            }
            ++n3;
        }
        this.prepareCompareSelfBinds(this.updateStmt, n2);
    }

    private void prepareUpdateRowStatement(int n) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        this.updateStmt = (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getUpdateSqlForUpdatableResultSet(this, n, this.rowBuffer, this.indexColsChanged));
        this.updateStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
    }

    public synchronized boolean previous() throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.previous();
    }

    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                if (this.isOnInsertRow()) {
                    DatabaseError.throwSqlException(84);
                }
                this.resultSet.refreshRow();
            }
        }
    }

    public synchronized boolean relative(int n) throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.relative(n);
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        this.resultSet.setFetchDirection(n);
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.resultSet.setFetchSize(n);
    }

    private void setIsNull(int n) {
        this.wasNull = n;
    }

    private void setIsNull(boolean bl) {
        this.wasNull = bl ? 1 : 2;
    }

    private void setRowBufferAt(int n, Object object, int[] nArray) throws SQLException {
        if (!this.isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                DatabaseError.throwSqlException(82);
            } else {
                this.isUpdating = true;
            }
        }
        if (n < 1 || n > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "setRowBufferAt");
        }
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            int n2 = 0;
            while (n2 < this.getColumnCount()) {
                this.m_nullIndicator[n2] = false;
                ++n2;
            }
        }
        if (nArray != null) {
            if (this.typeInfo == null) {
                this.typeInfo = new int[this.getColumnCount()][];
            }
            this.typeInfo[n] = nArray;
        }
        this.rowBuffer[n] = object;
        this.m_nullIndicator[n] = object == null;
    }

    private void setRowBufferAt(int n, Datum datum) throws SQLException {
        this.setRowBufferAt(n, datum, null);
    }

    public void updateARRAY(int n, ARRAY aRRAY) throws SQLException {
        this.updateOracleObject(n, (Datum)aRRAY);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.updateARRAY(n, (ARRAY)array);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.getInternalMetadata().getColumnType(1 + n);
        if (inputStream != null && n2 > 0) {
            if (!this.isStreamType(n3)) {
                byte[] byArray = new byte[n2];
                try {
                    int n4 = inputStream.read(byArray);
                    inputStream.close();
                    if (n4 <= 0) {
                        this.updateNull(n);
                        return;
                    }
                    String string = new String(byArray, 0, n4);
                    this.updateString(n, string);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n2, 1};
                this.setRowBufferAt(n, inputStream, nArray);
            }
        } else {
            this.setRowBufferAt(n, null);
        }
    }

    public void updateBFILE(int n, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n, (Datum)bFILE);
    }

    public void updateBLOB(int n, BLOB bLOB) throws SQLException {
        this.updateOracleObject(n, (Datum)bLOB);
    }

    public void updateBfile(int n, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n, (Datum)bFILE);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.getInternalMetadata().getColumnType(1 + n);
        if (inputStream != null && n2 > 0) {
            if (!this.isStreamType(n3)) {
                byte[] byArray = new byte[n2];
                try {
                    int n4 = inputStream.read(byArray);
                    inputStream.close();
                    if (n4 < n2) {
                        byte[] byArray2 = new byte[n4];
                        System.arraycopy(byArray, 0, byArray2, 0, n4);
                        byArray = byArray2;
                    } else if (n4 <= 0) {
                        this.updateNull(n);
                        return;
                    }
                    this.updateBytes(n, byArray);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n2, 2};
                this.setRowBufferAt(n, inputStream, nArray);
            }
        } else {
            this.setRowBufferAt(n, null);
        }
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateBLOB(n, (BLOB)blob);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Integer(by));
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateCHAR(int n, CHAR cHAR) throws SQLException {
        this.updateOracleObject(n, (Datum)cHAR);
    }

    public void updateCLOB(int n, CLOB cLOB) throws SQLException {
        this.updateOracleObject(n, (Datum)cLOB);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        int n3 = this.getInternalMetadata().getColumnType(1 + n);
        if (reader != null && n2 > 0) {
            if (!this.isStreamType(n3)) {
                char[] cArray = new char[n2];
                try {
                    int n4 = reader.read(cArray);
                    reader.close();
                    if (n4 <= 0) {
                        this.updateNull(n);
                        return;
                    }
                    String string = new String(cArray, 0, n4);
                    this.updateString(n, string);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n2};
                this.setRowBufferAt(n, reader, nArray);
            }
        } else {
            this.setRowBufferAt(n, null);
        }
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateCLOB(n, (CLOB)clob);
    }

    public void updateCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
    }

    public void updateDATE(int n, DATE dATE) throws SQLException {
        this.updateOracleObject(n, (Datum)dATE);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateINTERVALDS(int n, INTERVALDS iNTERVALDS) throws SQLException {
        this.updateOracleObject(n, (Datum)iNTERVALDS);
    }

    public void updateINTERVALYM(int n, INTERVALYM iNTERVALYM) throws SQLException {
        this.updateOracleObject(n, (Datum)iNTERVALYM);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateNUMBER(int n, NUMBER nUMBER) throws SQLException {
        this.updateOracleObject(n, (Datum)nUMBER);
    }

    public synchronized void updateNull(int n) throws SQLException {
        this.setRowBufferAt(n, null);
    }

    public void updateOPAQUE(int n, OPAQUE oPAQUE) throws SQLException {
        this.updateOracleObject(n, (Datum)oPAQUE);
    }

    public void updateORAData(int n, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.connection);
        this.updateOracleObject(n, datum);
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        Datum datum = null;
        if (object != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                int n2 = n + 1;
                datum = SQLUtil.makeOracleDatum(this.connection, object, oracleResultSetMetaData.getColumnType(n2), null, oracleResultSetMetaData.isNCHAR(n2));
            }
        }
        this.setRowBufferAt(n, datum);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public synchronized void updateOracleObject(int n, Datum datum) throws SQLException {
        this.setRowBufferAt(n, datum);
    }

    public void updateRAW(int n, RAW rAW) throws SQLException {
        this.updateOracleObject(n, (Datum)rAW);
    }

    public void updateREF(int n, REF rEF) throws SQLException {
        this.updateOracleObject(n, (Datum)rEF);
    }

    public void updateROWID(int n, ROWID rOWID) throws SQLException {
        this.updateOracleObject(n, (Datum)rOWID);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateREF(n, (REF)ref);
    }

    public void updateRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                int n;
                if (this.isOnInsertRow()) {
                    DatabaseError.throwSqlException(84);
                }
                if ((n = this.getNumColumnsChanged()) > 0) {
                    this.prepareUpdateRowStatement(n);
                    this.prepareUpdateRowBinds(n);
                    this.executeUpdateRow();
                }
            }
        }
    }

    public void updateSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        this.updateOracleObject(n, (Datum)sTRUCT);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Integer(s));
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateTIMESTAMP(int n, TIMESTAMP tIMESTAMP) throws SQLException {
        this.updateOracleObject(n, (Datum)tIMESTAMP);
    }

    public void updateTIMESTAMPLTZ(int n, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.updateOracleObject(n, (Datum)tIMESTAMPLTZ);
    }

    public void updateTIMESTAMPTZ(int n, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.updateOracleObject(n, (Datum)tIMESTAMPTZ);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public synchronized boolean wasNull() throws SQLException {
        switch (this.wasNull) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 4: {
                return this.resultSet.wasNull();
            }
        }
        DatabaseError.throwSqlException(24);
        return false;
    }
}

