/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;

public class OracleTypeREF
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3186448715463064573L;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:36:21_PST_2008";

    protected OracleTypeREF() {
    }

    public OracleTypeREF(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, oracleConnection);
    }

    public OracleTypeREF(OracleTypeADT oracleTypeADT, int n, OracleConnection oracleConnection) {
        super(oracleTypeADT, n, oracleConnection);
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        if (this.descriptor == null) {
            if (this.sqlName == null && this.getFullName(false) == null) {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getParent(), this.getOrder(), (Connection)this.connection);
                this.descriptor = new StructDescriptor(oracleTypeADT, (Connection)this.connection);
            } else {
                this.descriptor = StructDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
            }
        }
        return (StructDescriptor)this.descriptor;
    }

    public int getTypeCode() {
        return 2006;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        REF rEF = null;
        if (object != null) {
            if (object instanceof REF) {
                rEF = (REF)object;
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return rEF;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n == 1 || n == 2) {
            StructDescriptor structDescriptor = this.createStructDescriptor();
            return new REF(structDescriptor, (Connection)this.connection, byArray);
        }
        if (n == 3) {
            return byArray;
        }
        DatabaseError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        switch (n) {
            case 1: {
                if (unpickleContext.isNull(this.nullOffset)) {
                    return null;
                }
                unpickleContext.skipTo(unpickleContext.ldsOffsets[this.ldsOffset]);
                if (n2 == 9) {
                    unpickleContext.skipBytes(4);
                    return null;
                }
                unpickleContext.markAndSkip();
                byte[] byArray = unpickleContext.readPtrBytes();
                unpickleContext.reset();
                return this.toObject(byArray, n2, null);
            }
            case 2: {
                if ((unpickleContext.readByte() & 1) == 1) {
                    unpickleContext.skipPtrBytes();
                    return null;
                }
            }
            case 3: {
                if (n2 == 9) {
                    unpickleContext.skipPtrBytes();
                    return null;
                }
                return this.toObject(unpickleContext.readPtrBytes(), n2, null);
            }
        }
        DatabaseError.throwSqlException(1, "format=" + n);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

