/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSPatch;

public class TDSReader {
    static final int KOPT_NONE_FINAL_TYPE = 1;
    static final int KOPT_JAVA_OBJECT = 2;
    int nullOffset = 0;
    int ldsOffset = 0;
    long fixedDataSize = 0L;
    Vector patches = null;
    byte[] tds;
    int beginIndex;
    int index;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:36:21_PST_2008";

    TDSReader(byte[] byArray, long l) {
        this.tds = byArray;
        this.beginIndex = (int)l;
        this.index = (int)l;
    }

    long absoluteOffset() throws SQLException {
        return this.index;
    }

    void addNormalPatch(long l, byte by, OracleType oracleType) throws SQLException {
        this.addPatch(new TDSPatch(0, oracleType, l, by));
    }

    void addPatch(TDSPatch tDSPatch) throws SQLException {
        if (this.patches == null) {
            this.patches = new Vector(5);
        }
        this.patches.addElement(tDSPatch);
    }

    void addSimplePatch(long l, OracleType oracleType) throws SQLException {
        this.addPatch(new TDSPatch(1, oracleType, l, 0));
    }

    void checkNextByte(byte by) throws SQLException {
        block2: {
            try {
                if (by == this.tds[this.index]) break block2;
                DatabaseError.throwSqlException(47, "parseTDS");
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
    }

    TDSPatch getNextPatch() throws SQLException {
        TDSPatch tDSPatch = null;
        if (this.patches != null && this.patches.size() > 0) {
            tDSPatch = (TDSPatch)this.patches.firstElement();
            this.patches.removeElementAt(0);
        }
        return tDSPatch;
    }

    boolean isFinalType(int n, byte by) {
        return n >= 3 && (by & 1) == 0;
    }

    boolean isJavaObject(int n, byte by) {
        return n >= 3 && (by & 2) != 0;
    }

    long moveToPatchPos(TDSPatch tDSPatch) throws SQLException {
        long l = tDSPatch.getPosition();
        if ((long)this.beginIndex + l > (long)this.tds.length) {
            DatabaseError.throwSqlException(47, "parseTDS");
        }
        this.skip_to(l);
        return l;
    }

    long offset() throws SQLException {
        return this.index - this.beginIndex;
    }

    byte readByte() throws SQLException {
        try {
            byte by = this.tds[this.index];
            Object var3_2 = null;
            ++this.index;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
    }

    long readLong() throws SQLException {
        try {
            long l = (((this.tds[this.index] & 0xFF) * 256 + (this.tds[this.index + 1] & 0xFF)) * 256 + (this.tds[this.index + 2] & 0xFF)) * 256 + (this.tds[this.index + 3] & 0xFF);
            Object var4_2 = null;
            this.index += 4;
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.index += 4;
            throw throwable;
        }
    }

    short readShort() throws SQLException {
        try {
            short s = (short)((this.tds[this.index] & 0xFF) * 256 + (this.tds[this.index + 1] & 0xFF));
            Object var3_2 = null;
            this.index += 2;
            return s;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.index += 2;
            throw throwable;
        }
    }

    int readUnsignedByte() throws SQLException {
        try {
            int n = this.tds[this.index] & 0xFF;
            Object var3_2 = null;
            ++this.index;
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
    }

    void skipBytes(int n) throws SQLException {
        this.index += n;
    }

    void skip_to(long l) {
        this.index = this.beginIndex + (int)l;
    }

    byte[] tds() throws SQLException {
        return this.tds;
    }
}

